function sysParamOut = transformBasis(sysParam,P)
% Change of basis for parameters of a LDS  
%
% Given an invertible matrix P, this function transforms the parameters 
% of the LDS in the following manner 
%           A  = P.A.inv(P)
%           C  = C.inv(P)  
%     (Z,Z0,B) = P.(Z,Z0,B) 
%
% INPUTS
%   sysParam    - Input system structure with LDS parameters (order n)
%   P           - Change of basis matrix (nxn) that needs to be applied.
%
% OUTPUTS
%   sysParamOut - Structure containing systems parameters in the new basis.
%
% EXAMPLE
% 
%
%% Written by : Avinash Ravichandran, Rizwan Chaudhry
%% $DATE      : 09-Sep-2011 17:57:43 $
%% $REVISION  : 0.5.0 $

sysParamOut = sysParam;

if isfield(sysParam, 'C')
    sysParamOut.C = sysParam.C*inv(P);
end


if isfield(sysParam, 'A')
    sysParamOut.A = P*sysParam.A*inv(P);
end


if isfield(sysParam, 'Z')
    sysParamOut.Z = P*sysParam.Z;
end


if isfield(sysParam, 'Z0')
    sysParamOut.Z0 = P*sysParam.Z0;
end


if isfield(sysParam, 'B')
    sysParamOut.B = P*sysParam.B;
end
