function kNorm = normalizeKernel(K)
% Normalize Kernel between [0 1]
%
% This function normalizes a  kernel such that the values between 0 and 1.
% The normalization is done such that Kn(i,J) = K(i,j)/sqrt(K(i,i).K(j,j))
%
% INPUTS
%   K       - Kernel matrix
%
% OUTPUTS
%   kNorm   - normalized kernel matrix
%
% EXAMPLE
%   Kn = normalizeKernel(K);
%
%% Written by : Avinash Ravichandran, Rizwan Chaudhry
%% $DATE      : 09-Sep-2011 17:57:43 $
%% $REVISION  : 0.5.0 $

N = size(K,1);

kNorm = zeros(N,N);

for i=1:N
    for j =1:N
        kNorm(i,j) = K(i,j)/sqrt(K(i,i)*K(j,j));
    end
end
    


