function [Q,N,AR] = realJordanForm(A)
% Converts a matrix into its real Jordan form 
% 
% Converts the given matrix into real Jordan form. The eigen values are
% arranged in ascending order for the canonical form
% 
% INPUTS 
%   A      - The matrix which needs to be converted to real Jordan form
% 
% OUTPUTS 
%   Q      - The similarity transform that converts the matrix into the form
%   N      - Nx1 vector contains if the column of Q corresponds to
%            real/imag parts (1-real 0-imag)
%   AR     - The input A matrix in the real Jordan form.
%            
% 
% EXAMPLE 
% [Q,N,AR] = realJordanForm(A)

%% Written by : Avinash Ravichandran, Rizwan Chaudhry
%% $DATE      : 09-Sep-2011 17:57:43 $
%% $Revision   : 1.00 $ 
%% Matlab      : 7.4.0.287 (R2007a) 
%% FILENAME    : realJordanForm.m 
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Algorithm Parameter
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n     = size(A,2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculating and Sorting Eigenvectors
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[V,D] = eigs(full(A),n);
P     = diag(D);

% Sorting the eigen values
[temp,idx]=sort(abs(imag(P)));
P = P(idx);
V = V(:,idx);

% Finding if the eigen value is real or complex
for i=1:n
    lm(i)  = isreal(P(i));
end

[temp,idx] = sort(real(P.*lm'),'descend');
P  = P(idx);
V  = V(:,idx);
lm = lm(idx);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculating the transformation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Q = [];
N = [];
count=1;
while (count <= n )
    if (lm(count) == 1)
        Q     = [Q, V(:,count)./V(1,count)]; % Change
        AR(count,count)=P(count);
        count = count+1;
        N     = [N 1];
    else
        Q     = [Q, real(V(:,count)), imag(V(:,count+1))];
        AR(count:count+1,count:count+1)=[real(P(count)) imag(P(count));-imag(P(count)) real(P(count))];
        count = count+2;
        N     = [N 1 0];
    end
end

Q = inv(Q);


