function  theta = subspaceAnglesARMA(sys1, sys2)
% Calculates the subspace angles between two ARMA systems
%
% INPUTS
%   sys1:     System 1
%   sys2:     System 2
%
% OUTPUTS
%   angles:   The subspace angles sorted in ascending order in rad
%
% EXAMPLE
% 
%
%% Written by : Avinash Ravichandran, Rizwan Chaudhry
%% $DATE      : 09-Sep-2011 17:57:43 $
%% $REVISION  : 0.5.0 $

A1 = sys1.A;
K1 = sys1.K;
C1 = sys1.C;
A2 = sys2.A;
K2 = sys2.K;
C2 = sys2.C;

n = size(A1,1);
m = size(C1,1);
A = [ A1 zeros(n,3*n); zeros(n) A2-K2*C2 zeros(n,2*n); ...
    zeros(n,2*n) A2 zeros(n); zeros(n,3*n) A1-K1*C1];
C = [ C1 -C2 C2 -C1];
Q = dlyap(A',C'*C);
E = eig([zeros(2*n) pinv(Q(1:2*n,1:2*n))*Q(1:2*n,2*n+1:4*n);...
    pinv(Q(2*n+1:4*n,2*n+1:4*n))*Q(2*n+1:4*n,1:2*n) zeros(2*n)]);
E = real(E);
E = max(-ones(size(E)),E);
E = min(ones(size(E)),E);
E = sort(E,'descend');
theta = acos(E(1:2*n));

% theta = acos(E(1:n));   % Just to check how recognition performs with
% just n subspace angles
