% This is an example of human gait modeling, where because of the
% low-dimensional output, we can use optimal system ID

load ../data/cutsequence01_01.mat

dParams.class = 4;
sysParam = optimalSystemID(data,[10 1],dParams);

numReal = 100;
K = zeros([size(data),numReal]);
for i = 1:numReal
    K(:,:,i) = generateFromLDS(sysParam,size(data));
end

subplot(1,2,1); plot(data');
title('Original');
subplot(1,2,2); plot(mean(K,3)');
title(['Mean of ', int2str(numReal), ' realizations']);
