% This example demonstrates how we can learn and synthesize gray videos of dynamic textures. 

load ../data/ocean-gray

dParams.class = 2;  
sysParam = suboptimalSystemID(grayMat,[50 1],dParams);
K = generateFromLDS(sysParam,size(grayMat));   

for i=1:size(K,3);
    subplot(1,2,1);
    imagesc(grayMat(:,:,i),[0 255]);
    colormap gray;
    axis off;
    title('Original');

    subplot(1,2,2);
    imagesc(K(:,:,i),[0 255]);
    colormap(gray);
    axis off;
    title('Synthesized');
    drawnow;
end
