% Y: D x N matrix of N data points in D dimensional space
% y: D x 1 test data vector
% Tn: vector of n elements indicating the number of trainings for each of
% the n class
% sub: index of the groundtruth subject for the test data y
% thr: error threshold for the sparse recovery using L1/Lq optimization
% q: norm used for block sparse recovery using L1/Lq
% Bsr1: {0,1} Block sparse recovery using P'_{L1/Lq} is successful if 1
% Bsr2: {0,1} Block sparse recovery using P_{L1/Lq} is successful if 1
% err_Bsr1: distance of y from each subject using coef. vecors P'_{L1/Lq}
% err_Bsr2: distance of y from each subject using coef. vecors P_{L1/Lq}
%--------------------------------------------------------------------------
% Copyright @ Ehsan Elhamifar, 2012
%--------------------------------------------------------------------------

function [Bsr1,Bsr2,err_Bsr1,err_Bsr2] = BlockSparse(Y,y,Tn,sub,thr,q)

n = length(Tn);
N = sum(Tn);

cvx_begin
variable c1(N,1)
t1 = 0;
ind = 0;
for i = 1:n
    X(:,:,i) = Y(:,ind+1:ind+Tn(i));
    t1 = t1 + norm( X(:,:,i) * c1(ind+1:ind+Tn(i)) , q );
    ind = ind + Tn(i);
end
minimize( t1 )
subject to
norm(y - Y * c1) <= thr;
cvx_end


cvx_begin
variable c2(N,1)
t2 = 0;
ind = 0;
for i = 1:n
    t2 = t2 + norm( c2(ind+1:ind+Tn(i)) , q );
    ind = ind + Tn(i);
end
minimize( t2 )
subject to
norm(y - Y * c2) <= thr;
cvx_end


ind = 0;
for i = 1:n
    err_Bsr1(i) = norm( y - X(:,:,i) * c1(ind+1:ind+Tn(i)) );
    err_Bsr2(i) = norm( y - X(:,:,i) * c2(ind+1:ind+Tn(i)) );
    ind = ind + Tn(i);
end
[m1,ind1] = min(err_Bsr1);
if ind1 == sub
    Bsr1 = 1;
else
    Bsr1 = 0;
end
[m2,ind2] = min(err_Bsr2);
if ind2 == sub
    Bsr2 = 1;
else
    Bsr2 = 0;
end