% This is the function to solve for three different convex optimizations
% B: D x d x n tensor where each B(:,:,i) denotes vectors in subspace i
% Dimension of all subspaces is assumed to be d
% k: sparsity degree of the vector y
% noise: noise level
% c1: block sparse recovery using mixed Lq/L1 method 1
% c2: block sparse recovery using mixed Lq/L1 method 2
%--------------------------------------------------------------------------
% Copyright @ Ehsan Elhamifar, 2012
%--------------------------------------------------------------------------

function [Bsr1,Bsr2,Sr,err_Bsr1,err_Bsr2,err_Sr] = BlockSparseDisguise(y,B,sub,q)

D = size(B,1);
d = size(B,2);
n = size(B,3);
Blk = [];
for i = 1:n
    Blk = [Blk B(:,:,i)];
end

%cvx_precision high

cvx_begin
variable c1(n*d+D,1)
t1 = 0;
for i = 1:n
    t1 = t1 + norm( B(:,:,i) * c1( (i-1)*d+1 : i*d ) , q );
end
for i = 1:D
    t1 = t1 + abs(c1(n*d+i));
end
minimize( t1 )
subject to
y == [Blk eye(D)] * c1;
cvx_end


cvx_begin
variable c2(n*d+D,1)
t2 = 0;
for i = 1:n
    t2 = t2 + norm( c2( (i-1)*d+1 : i*d ) , q );
end
for i = 1:D
    t2 = t2 + abs(c2(n*d+i));
end
minimize( t2 )
subject to
y == [Blk eye(D)] * c2;
cvx_end


cvx_begin
variable c3(n*d+D,1)
minimize( norm(c3,1) )
subject to
y == [Blk eye(D)] * c3;
cvx_end


for i = 1:n
    err_Bsr1(i) = norm( y - B(:,:,i) * c1((i-1)*d+1:i*d) - c1(n*d+1:end) );
    err_Bsr2(i) = norm( y - B(:,:,i) * c2((i-1)*d+1:i*d) - c2(n*d+1:end) );
    err_Sr(i) = norm( y - B(:,:,i) * c3((i-1)*d+1:i*d) - c3(n*d+1:end) );
end

[m1,ind1] = min(err_Bsr1);
if ind1 == sub
    Bsr1 = 1;
else
    Bsr1 = 0;
end

[m2,ind2] = min(err_Bsr2);
if ind2 == sub
    Bsr2 = 1;
else
    Bsr2 = 0;
end

[m3,ind3] = min(err_Sr);
if ind3 == sub
    Sr = 1;
else
    Sr = 0;
end