% This m-file runs the block-sparse recovery using three convex programs
% based on L2/L1, L1/L1, and Linf/L1 optimization on the Extended Yale B 
% database.
% avgrecrate: average recognition rate for the three optimization programs
%--------------------------------------------------------------------------
% Copyright @ Ehsan Elhamifar, 2012
%--------------------------------------------------------------------------

clc, clear all, close all

load ARCrop.mat
load TrainTestIndx_AR_Disguise.mat

d = 9; % number of training for each subject/class
Type = 'G'; % type of disguise {Glasses,Scarf}
iter = 1; % number of classification trials
r0 = 10/38; % downsampling size [1/7-->432, 10/38-->1408]

M = [5 9 13];

dix = find(M == d);
N = size(I,3); % number of images for each subject
n = size(I,4); % number of subjects/classes

% scale for downsampling images 1/16==132, 1/8==504
Y = [];
B = ImageDownSample(I,r0);
D = size(B,1); % projection dimension

for k = 1:iter
    Ytrain = [];
    Ytest = [];
    for i = 1:n
        Trn = Tr{dix}(:,i,k);
        
        if Type == 'G'
            Tst = Ts_G{dix}(:,i,k);
            Txt = strcat('AR_Disguise_','Glass_','G',num2str(n),'D',num2str(D),'d',num2str(d));
        elseif Type == 'S'
            Tst = Ts_S{dix}(:,i,k);
            Txt = strcat('AR_Disguise_','Scarf_','G',num2str(n),'D',num2str(D),'d',num2str(d));
        end
        
        Ytrain(:,:,i) = MatrixNormalize( B(:,Trn,i) );
        Ytest(:,:,i) =  MatrixNormalize( B(:,Tst,i) );
    end
    
    for i = 1:n
        sub = i;
        for j = 1:size(Tst,1)
            y = Ytest(:,j,i);

            q = 2;
            [Bsr1,Bsr2,Sr,err_Bsr1,err_Bsr2,err_Sr] = BlockSparseDisguise(y,Ytrain,sub,q);
            facerec(i,j,k,1) = Bsr1;
            facerec(i,j,k,2) = Bsr2;
            facerec(i,j,k,3) = Sr;

            eval(['save ' Txt '.mat facerec n D d r0 Tr Ts_G Ts_S'])
        end
    end
    eval(['save ' Txt '.mat facerec n D d r0 Tr Ts_G Ts_S'])  
end

for p = 1:3
    for k = 1:iter
        facerecTot(k,p) = sum( sum( facerec(:,:,k,p) ) ) / ( size(facerec,1) * size(facerec,2) );
    end
    avgrecrate(p) = mean(facerecTot(:,p));
    maxrecrate(p) = max(facerecTot(:,p));
end
eval(['save ' Txt '.mat avgrecrate maxrecrate facerec facerecTot n D d r0 Tr Ts_G Ts_S'])