% Y: D x N matrix of N data points in D dimensions
% d: dimension of projection
% Yp: d x N matrix of projected data points
% Up: D x d matrix of Randomfaces
%--------------------------------------------------------------------------
% Copyright @ Ehsan Elhamifar, 2012
%--------------------------------------------------------------------------


function [Yp,Up] = Randomface(Y,d)

D = size(Y,1);
PrN = normrnd(0,1/sqrt(d),[d D]);
for i = 1:d
    PrN(i,:) = PrN(i,:) ./ norm(PrN(i,:));
end
Yp = PrN * Y;
Up = PrN';