function image = imnormalize(I)
% IMNORMALIZE normalize an image to range [0, 255].

% Used for preprocessing image before imshow or imwrite.
% e.g.
%   imshow(imnormalize(I)); % equvalent to imshow(I, []);
%   imwrite(imnormalize(I))
% By Chong You, 2014
image = uint8(255 * (I-min(I(:))) / (max(I(:)) - min(I(:))));