function [groups, Affinity] = SASC_ABA( Y, n, n_v,p )

% Y: DxN data matrix
% n: number of clusters to be produced
% n_v: degree of veronese embedding

% groups: produced clusters

[D N] = size(Y);

%% compute a vanishing polynomial
[Ln,powers] = veronese(Y,n_v);
Ln = Ln';
[U,S,V] = svd(Ln);
Mn = nchoosek(n_v+D-1,n_v);
c = V(:,Mn);
powers = exponent(n_v,D);

%% construct the affinity matrix
[Dpn,normDpn] = cnormalize(derivative(c,powers,Y));
if p == 0.5
    Affinity = sqrt(abs(Dpn'*Dpn));
else
    Affinity = abs(Dpn' * Dpn).^p;
end

%% do spectral clustering
groups = SpectralClustering(Affinity,n);


end

