function coeff = gpca_lida(xx,c,n,K,powers,restarts)

err = 1e6;

if nargin < 6
  restarts = 1; % numer of random lines to be chosen
end

for lines=1:restarts
  % Intersect polynomial c with a random line
  v  = cnormalize(randn(K,1));
  x0 = cnormalize(randn(K,1));

  % Find univariate polynomial corresponding to the line
  line_c = line_coeff(c,v,x0,n,powers);
  % Use the roots to compute intersecting points
  points = [v x0]*[roots(line_c) ones(n,1)]';

  % Evaluate the derivative at each ppoint to get normal vectors
  for i=1:n
    bb(:,i) = cnormalize(derivative(c,powers,points(:,i)));
  end
  
  % Choosing the best line: the one with minimum reconstruction error

  newerr=sqrt(mean(min(abs(bb'*xx).^2,[],1)));
  if (newerr < err)
    coeff = bb;
    err = newerr;
  end

end

coeff = coeff';
